function S = updateSimilarity(A,S,direction,method)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

C = 1;



switch direction
    case 'both'
        num = (A*S*A') + (A'*S*A);
    case 'incoming'
        num = (A'*S*A);
    case 'outgoing'
        num = (A*S*A');
end

switch method
    case 'bloniarz'
        denom = (diag(num) * diag(num)').^(1/2);  %Adam's method for normalizing
    case 'blondel'
        denom = norm(num,'fro');       %Blondel method for normalizing
end

S = num./denom;
S(isnan(S)) = 0;




end

